<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package OceanWP WordPress theme
 */

get_header(); ?>
<section class="search-header">
 <div class="search-header-inner container">
<h2>All Exotic Destinations In Vietnam </h2>
</div>
</section>
<section class="promo-search-text">
<div class="container">
<h3> Little Saigon Tours Destinations</h3>
<p>We are Little Saigon Tours. We are Vietnam’s leading and most awarded travel company, honored to bring you rich, unique and local experiences in Ho Chi Minh city, across the country and worldwide. 

We have more than 30 years of specializing in tailor-made tours, group tours, and MICE services. That translates into providing the best service on a local, regional and global level. We work with not only a great professional attitude but also a strong passion for putting a smile on your face, everywhere you travel with us. </p>
</div>
</section>
	<?php do_action( 'ocean_before_content_wrap' ); ?>

	<div id="content-wrap" class="container clr">

		<?php do_action( 'ocean_before_primary' ); ?>

		<div id="primary" class="content-area clr">

			<?php do_action( 'ocean_before_content' ); ?>

			<div id="content" class="site-content site-content-search">

				<?php
				$logo_search = get_theme_mod( 'ocean_search_logo' );
				if ( ! empty( $logo_search ) ) {
					?>
					<img class="logo-search" src="<?php echo esc_url( $logo_search ); ?>" alt="<?php esc_attr_e( 'Search Logo', 'oceanwp' ); ?>" title="<?php esc_attr_e( 'Search Logo', 'oceanwp' ); ?>" />
				<?php } ?>
			
				<?php do_action( 'ocean_before_content_inner' ); ?>

				<?php if ( have_posts() ) : ?>

						<?php
						while ( have_posts() ) :
							the_post();
							?>

							<?php get_template_part( 'partials/search/layout' ); ?>

						<?php endwhile; ?>

					<?php oceanwp_pagination(); ?>

				<?php else : ?>

					<?php
					// Display no post found notice.
					get_template_part( 'partials/none' );
					?>

				<?php endif; ?>

				<?php do_action( 'ocean_after_content_inner' ); ?>

			</div><!-- #content -->
			

			<?php do_action( 'ocean_after_content' ); ?>

		</div><!-- #primary -->

		<?php do_action( 'ocean_after_primary' ); ?>

	</div><!-- #content-wrap -->

	<?php do_action( 'ocean_after_content_wrap' ); ?>

<?php get_footer(); ?>


<style>
.search-header {
    color: #fff;
    background: #000;
    padding: 80px 0 60px 0;
    text-align: center;
    border-bottom: 5px solid #e35c0d;
}
.search-header-inner h2{
	color:#fff;
	font-size:45px;
}
.promo-search-text{
	padding:50px 0 30px 0;
}

.promo-search-text h3{
	font-size:36px;
}

</style>