<?php
/**
 * OceanWP Child Theme Functions
 *
 * When running a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions will be used.
 *
 * Text Domain: oceanwp
 * @link http://codex.wordpress.org/Plugin_API
 *
 */

/**
 * Load the parent style.css file
 *
 * @link http://codex.wordpress.org/Child_Themes
 */
function oceanwp_child_enqueue_parent_style() {

	// Dynamically get version number of the parent stylesheet (lets browsers re-cache your stylesheet when you update the theme).
	$theme   = wp_get_theme( 'OceanWP' );
	$version = $theme->get( 'Version' );

	// Load the stylesheet.
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'oceanwp-style' ), $version );
	
}

add_action( 'wp_enqueue_scripts', 'oceanwp_child_enqueue_parent_style' );


function rental_cars_custom_loop_with_category ( $atts ) {

//Run your Query

$args = array(
    'post_type'  => 'rental_cars',
    'post_status' => 'publish',
    'orderby'    => 'date',
    'order'      => 'DESC'
);
 $loop = new WP_Query( $args ); 

while ( $loop->have_posts() ) : $loop->the_post(); 
   
	 //Iterate and display output
    echo '<li><a href="'.get_permalink().'">'.get_the_title().'</a></li>'; 
endwhile;

wp_reset_postdata(); 

}

add_shortcode( 'rental_cars_archive', 'rental_cars_custom_loop_with_category' );





// custom shortcode for rental_cars post type archive for home




function rentalcarsarchive() {
    ob_start(); ?>
	<div class="rentalcars">
<?php 



	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$args = array(
    'post_type'=>'rental_cars', // Your post type name
    'posts_per_page' => 4,
	
    'paged' => $paged,
);
	
	

// query
$the_query = new WP_Query( $args );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>

		<div class="car-tile">
			
 <a class="car-page-link" href="<?php the_permalink(); ?>">
 <div id="custom-bg" class="car-img" style="background-image: url(<?php the_post_thumbnail_url(); ?>); "></div>

            </a>
	   
   
	     
	   
	     <div class="car-info">
			 <div class="tour-info"> 
			
                <h4>
               <a href="<?php the_permalink(); ?>" class="c-accl-post-thumb__link" rel="bookmark"><span class="c-accl-post-thumb__link-title"><?php the_title() ?></span></a>
                </h4>
		   <?php if ( get_field('tour_duration') ) : ?>
            <p class="price-per-day"><?php echo get_field('tour_duration'); ?></p>
            <?php endif; ?>
		   <?php if ( get_field('price') ) : ?>
            <p class="price-info">Price: <?php echo get_field('price'); ?> <?php else : ?>Price: Negotiatable</p>
            <?php endif; ?>
				  </div>
                <div class="car-card-cta tours">
               
	                        
<a id="myBtn<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>"><p class="whatsapp-cta"><i class="fa-solid fa-envelope" aria-hidden="true"></i> Contact Us</p></a>
	<div id="myModal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>" class="modal modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>">

  <!-- Modal content -->
  <div class="modal-content">
	  <span class="close close<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>">&times;</span>
	  <?php the_title(); ?>
    <?php echo do_shortcode('[contact-form-7 id="2515" title="Contact form 7-archive-tours"]') ;?>
  </div>

</div>				
					
					
<script>
// Get the modal
var modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?> = document.getElementById("myModal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>");

// Get the button that opens the modal
var btn = document.getElementById("myBtn<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>")[0];

// When the user clicks the button, open the modal 
btn.onclick = function() {
  modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>) {
    modal<?php echo bl_get_post_id_by_title( 'Digitized motivating structure' );?>.style.display = "none";
  }
}
</script>
				
					
                </div>
            </div>
	   
	 
</div>

	
	   



	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query();	 // Restore global post data stomped by the_post(). ?>
</div>

<?php

    return ob_get_clean();
}

add_shortcode('rentalcarshome', 'rentalcarsarchive');



// custom shortcode for rental_cars post type archive for home




function offerrentalcarsarchive() {
    ob_start(); ?>
	<div class="offerrentalcars">
<?php 

// args
$args = array(
	'numberposts'	=> -1,
	'post_type'		=> 'rental_cars',
	
);


// query
$the_query = new WP_Query( $args );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div class="car-tile">
    
	   
	   
	   
	   <a class="car-page-link" href="<?php the_permalink(); ?>">
 <div id="custom-bg" class="car-img" style="background-image: url(<?php the_post_thumbnail_url(); ?>); "></div>
    <div class="car-price-card offer">
			<div class="price-option">
						
						<div class="price-option-price">
						 <?php if ( get_field('offer_price_per_half_day') ) : ?>
            <p class="offer-price-per-day"><?php echo get_field('offer_price_per_half_day'); ?> / Half Day</p>
            <?php endif; ?>
						<?php if ( get_field('price_per_half_day') ) : ?>
            <p class="price-per-day"><?php echo get_field('price_per_half_day'); ?> / Half Day</p>
            <?php endif; ?>
						</div>
           </div>
			<div class="price-option">
			
				
				<div class="price-option-price">
				<?php if ( get_field('offer_price_per_week') ) : ?>
            <p class="offer-price-per-week"><?php echo get_field('offer_price_per_week'); ?> / Week</p>
            <?php endif; ?>
					<?php if ( get_field('price_per_week') ) : ?>
            <p class="price-per-week"><?php echo get_field('price_per_week'); ?> / Week</p>
            <?php endif; ?>
				</div>
			</div>
			<div class="price-option">
		
				
				<div class="price-option-price">
				<?php if ( get_field('offer_price_per_day') ) : ?>
            <p class="offer-price-per-day"><?php echo get_field('offer_price_per_day'); ?> / Day</p>
            <?php endif; ?>
						<?php if ( get_field('price_per_day') ) : ?>
            <p class="price-per-day"><?php echo get_field('price_per_day'); ?> / Day</p>
            <?php endif; ?>
				</div></div>
						
					
		
             <div class="price-option">
				
		    
				<div class="price-option-price">
					<?php if ( get_field('offer_price_per_month') ) : ?>
            <p class="offer-price-per-month"><?php echo get_field('offer_price_per_month'); ?> / Month</p>
            <?php endif; ?>  
				  <?php if ( get_field('price_per_month') ) : ?>
            <p class="price-per-month"><?php echo get_field('price_per_month'); ?> / Month</p>
            <?php endif; ?>
				  </div></div>
			
             </div>
          
            </a>
	   
	   
   <div class="car-info">
	    <div class="tour-info"> 
                <h4>
               <a href="<?php the_permalink(); ?>" class="c-accl-post-thumb__link" rel="bookmark"><span class="c-accl-post-thumb__link-title"><?php the_title() ?></span></a>
                </h4>
		   <?php if ( get_field('tour_duration') ) : ?>
            <p class="price-per-day"><?php echo get_field('tour_duration'); ?></p>
            <?php endif; ?>
		   <?php if ( get_field('price') ) : ?>
            <p class="price-info">Price: <?php echo get_field('price'); ?> <?php else : ?>Price: Negotiatable</p>
            <?php endif; ?>
	   </div>
			
                <div class="car-card-cta">
                   <a class="call-cta-link" href="#"><p class="whatsapp-cta"><i class="fa-solid fa-envelope" aria-hidden="true"></i> Contact Us</p></a>
               
                </div>
            </div>
	   
	 
</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query();	 // Restore global post data stomped by the_post(). ?>
</div>

<?php

    return ob_get_clean();
}

add_shortcode('offerrentalcars', 'offerrentalcarsarchive');






// custom shortcode for rental_cars post type archive with paginate


function offerrentalcarsarchivewithpaginate() {
    ob_start(); ?>
	<div class="rentalcars">
<?php
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$args = array(
    'post_type'=>'rental_cars', // Your post type name
    'posts_per_page' => 6,
    'paged' => $paged,
);

$loop = new WP_Query( $args );
if ( $loop->have_posts() ) {
    while ( $loop->have_posts() ) : $loop->the_post();
	?>
	
	<div class="car-tile">
      
	
	   
	   
	   <a class="car-page-link" href="<?php the_permalink(); ?>">
 <div id="custom-bg" class="car-img" style="background-image: url(<?php the_post_thumbnail_url(); ?>); "></div>

           <div class="car-price-card offer">
			<div class="price-option">
						
						<div class="price-option-price">
						 <?php // if ( get_field('offer_price_per_half_day') ) : ?>
            <!--<p class="offer-price-per-day"><?php // echo get_field('offer_price_per_half_day'); ?> / Half Day</p>-->
            <?php // endif; ?>
						<?php if ( get_field('price_per_half_day') ) : ?>
            <p class="price-per-day"><?php echo get_field('price_per_half_day'); ?> / Half Day</p>
            <?php endif; ?>
						</div>
           </div>
		<!--<div class="price-option">
			
				
				<div class="price-option-price">
				<?php // if ( get_field('offer_price_per_week') ) : ?>
            <p class="offer-price-per-week"><?php // echo get_field('offer_price_per_week'); ?> / Week</p>
            <?php // endif; ?>
					<?php // if ( get_field('price_per_week') ) : ?>
            <p class="price-per-week"><?php // echo get_field('price_per_week'); ?> / Week</p>
            <?php // endif; ?>
				</div>
			</div>-->
			<div class="price-option">
		
				
				<div class="price-option-price">
				<?php // if ( get_field('offer_price_per_day') ) : ?>
            <!--<p class="offer-price-per-day"><?php // echo get_field('offer_price_per_day'); ?> / Day</p>-->
            <?php // endif; ?>
						<?php if ( get_field('price_per_day') ) : ?>
            <p class="price-per-day"><?php echo get_field('price_per_day'); ?> / Day</p>
            <?php endif; ?>
				</div></div>
						
					
		<!-- <div class="price-option">
				
		    
				<div class="price-option-price">
					<?php // if ( get_field('offer_price_per_month') ) : ?>
            <p class="offer-price-per-month"><?php // echo get_field('offer_price_per_month'); ?> / Month</p>
            <?php // endif; ?>  
				  <?php // if ( get_field('price_per_month') ) : ?>
            <p class="price-per-month"><?php // echo get_field('price_per_month'); ?> / Month</p>
            <?php // endif; ?>
				  </div></div>-->
            
			
             </div>
          
            </a>
	   
	   
   <div class="car-info">
	    <div class="tour-info"> 
                <h4>
               <a href="<?php the_permalink(); ?>" class="c-accl-post-thumb__link" rel="bookmark"><span class="c-accl-post-thumb__link-title"><?php the_title() ?></span></a>
                </h4>
		   <?php if ( get_field('tour_duration') ) : ?>
            <p class="price-per-day"><?php echo get_field('tour_duration'); ?></p>
            <?php endif; ?>
		   <?php if ( get_field('price') ) : ?>
            <p class="price-info">Price: <?php echo get_field('price'); ?> <?php else : ?>Price: Negotiatable</p>
            <?php endif; ?>
	   </div>
                <div class="car-card-cta">
                   <a class="call-cta-link" href="#"><p class="whatsapp-cta"><i class="fa-solid fa-envelope" aria-hidden="true"></i> Contact Us</p></a>
               
                </div>
            </div>
	   
	 
</div>
	
	<?php

    endwhile;
?></div><?php
    $total_pages = $loop->max_num_pages;

    if ($total_pages > 1){

        $current_page = max(1, get_query_var('paged'));

        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $total_pages,
            'prev_text'    => __('« prev'),
            'next_text'    => __('next »'),
        ));
    }    
}
wp_reset_postdata();
?>



<?php

    return ob_get_clean();
}

add_shortcode('offerrentalcars_with_paginate', 'offerrentalcarsarchivewithpaginate');







// custom shortcode for rental_cars post type archive with specific meta_key & paginate


function monthlyrentalcarswithpaginate() {
    ob_start(); ?>
	<div class="offerrentalcars">
<?php
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$args = array(
    'post_type'=>'rental_cars', // Your post type name
    'posts_per_page' => 6,
	'meta_key'		=> 'price_per_month',
    'paged' => $paged,
);

$loop = new WP_Query( $args );
if ( $loop->have_posts() ) {
    while ( $loop->have_posts() ) : $loop->the_post();
	?>
	
	<div class="car-tile">
		
			
           <a class="car-page-link" href="<?php the_permalink(); ?>">
 <div id="custom-bg" class="car-img" style="background-image: url(<?php the_post_thumbnail_url(); ?>); "></div>

                <div class="car-price-card offer monthy">
           
			
			   
			    <div class="price-option">
				
		    
				<div class="price-option-price">
					<?php // if ( get_field('offer_price_per_month') ) : ?>
            <!--<p class="offer-price-per-month"><?php // echo get_field('offer_price_per_month'); ?> / Month</p>-->
					
            <?php // endif; ?> 
				  <?php if ( get_field('price_per_month') ) : ?>
            <p class="price-per-month"><?php echo get_field('price_per_month'); ?> / Month <?php else: ?>Contact Us for Monthly Rent</p>
            <?php endif; ?>
						
				  </div></div>
			   
			   </div>
			   
			   
          
            </a>
	   
	   
	   <div class="car-info">
		    <div class="tour-info"> 
                <h4>
               <a href="<?php the_permalink(); ?>" class="c-accl-post-thumb__link" rel="bookmark"><span class="c-accl-post-thumb__link-title"><?php the_title() ?></span></a>
                </h4>
		   <?php if ( get_field('tour_duration') ) : ?>
            <p class="price-per-day"><?php echo get_field('tour_duration'); ?></p>
            <?php endif; ?>
		   <?php if ( get_field('price') ) : ?>
            <p class="price-info">Price: <?php echo get_field('price'); ?> <?php else : ?>Price: Negotiatable</p>
            <?php endif; ?>
		   </div>
                <div class="car-card-cta">
                   <a class="call-cta-link" href="#"><p class="whatsapp-cta"><i class="fa-solid fa-envelope" aria-hidden="true"></i> Contact Us</p></a>
               
                </div>
            </div>
			
		</div>
	
	<?php

    endwhile;
?></div><?php
    $total_pages = $loop->max_num_pages;

    if ($total_pages > 1){

        $current_page = max(1, get_query_var('paged'));

        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $total_pages,
            'prev_text'    => __('« prev'),
            'next_text'    => __('next »'),
        ));
    }    
}
wp_reset_postdata();
?>



<?php

    return ob_get_clean();
}

add_shortcode('monthlyrentalcars_with_paginate', 'monthlyrentalcarswithpaginate');




// custom shortcode for rental_cars post type archive with specific meta_key

function tourscontactpop() {
    ob_start(); ?>
<?php 

// args
$args = array(
	'numberposts'	=> 1,
	'post_type'		=> 'rental_cars',
	
);


// query
$the_query = new WP_Query( $args );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div class="car-tile">
                <h4>
              <span class="c-accl-post-thumb__link-title">Tour Name: <?php the_title() ?></span>
			</h4>
		</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query();	 // Restore global post data stomped by the_post(). ?>

<?php

    return ob_get_clean();
}

add_shortcode('tourscontactpoptitle', 'tourscontactpop');






// custom serach for rental_cars post type


function searchfilter($query) {
 
    if ($query->is_search && !is_admin() ) {
        $query->set('post_type',array('rental_cars'));
    }
 
return $query;
}
 
add_filter('pre_get_posts','searchfilter');

/* Register custom widget */

function register_custom_widget_area() {
register_sidebar(
array(
'id' => 'sidebar_dest',
'name' => esc_html__( 'Sidebar Destinatiins', 'theme-domain' ),
'description' => esc_html__( 'idebar Destinatiins', 'theme-domain' ),
'before_widget' => '<div id="%1$s" class="widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="widget-title-holder"><h3 class="widget-title">',
'after_title' => '</h3></div>'
)
);

register_sidebar(
array(
'id' => 'sidebar_tour_type',
'name' => esc_html__( 'Sidebar Tours Type', 'theme-domain' ),
'description' => esc_html__( 'Sidebar Tours Type', 'theme-domain' ),
'before_widget' => '<div id="%1$s" class="widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="widget-title-holder"><h3 class="widget-title">',
'after_title' => '</h3></div>'
)
);
	
	
}
add_action( 'widgets_init', 'register_custom_widget_area' );



// custom shortcode for renta a car services archive top section 

function servicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1298' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div class="service-top-wr">

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-rent-a-car-top', 'servicetopsection');



// custom shortcode for van services archive top section 

function vanservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1302' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-van-top', 'vanservicetopsection');


// custom shortcode for bus services archive top section 

function busservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1330' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-bus-top', 'busservicetopsection');


// custom shortcode for wedding services archive top section 

function weddingservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1332' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-wedding-top', 'weddingservicetopsection');


// custom shortcode for taxi services archive top section 

function taxiservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1334' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-taxi-top', 'taxiservicetopsection');


// custom shortcode for corporate services archive top section 

function corporateservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1336' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-corporate-top', 'corporateservicetopsection');


// custom shortcode for chauffeur services archive top section 

function chauffeurservicetopsection() {
    ob_start(); ?>
<?php 


// query
$the_query = new WP_Query( 'post_type=html_block&p=1340' );

?>
<?php if( $the_query->have_posts() ): ?>
	
	<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
<div class="service-top-wr">
	

		<div class="service-top-left">		
       <h2><?php the_title();?></h2>
		 <p><?php the_content();?></p> 
		</div>
<div class="service-top-right"> <img src="<?php the_post_thumbnail_url(); ?>" alt="" />	</div>
	</div>
	<?php endwhile; ?>
	
<?php endif; ?>

<?php wp_reset_query(); ?>

<?php

    return ob_get_clean();
}

add_shortcode('service-chauffeur-top', 'chauffeurservicetopsection');





// Function to get WordPress post ID given the post title
function bl_get_post_id_by_title( string $title = '' ): int {
    $posts = get_posts(
        array(
            'post_type'              => 'rental_cars',
            'title'                  => $title,
            'numberposts'            => 1,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
            'orderby'                => 'post_date ID',
            'order'                  => 'ASC',
            'fields'                 => 'ids'
        )
    );

    return empty( $posts ) ? get_the_ID() : $posts[0];
}

